class Turd expands DeusExDecoration;

var FlyGenerator flyGen;			// fly generator

#exec MESH IMPORT MESH=turd ANIVFILE=C:\DeusEx\MODELS\turd_a.3d DATAFILE=C:\DeusEx\MODELS\turd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=turd X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=turd SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=turd SEQ=Still STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW MESHMAP=turd MESH=turd
#exec MESHMAP SCALE MESHMAP=turd X=0.1 Y=0.1 Z=0.2

#exec TEXTURE IMPORT NAME=Poo FILE=C:\DeusEx\Markistan\textures\Poo.pcx GROUP=Skins FLAGS=2
#exec TEXTURE IMPORT NAME=Poo FILE=C:\DeusEx\Markistan\textures\Poo.pcx GROUP=Skins PALETTE=Jtex1
#exec MESHMAP SETTEXTURE MESHMAP=turd NUM=1 TEXTURE=Poo

#exec AUDIO IMPORT FILE="C:\DeusEx\Markistan\MarkistanSounds\Fart.wav"				NAME="Fart"			GROUP="Misc"

// ----------------------------------------------------------------------
// PreBeginPlay()
// ----------------------------------------------------------------------

function PreBeginPlay()
{
	Super.PreBeginPlay();

	// Bind any conversation events to this Decoration
//	ConBindEvents();

	if (bGenerateFlies)
		flyGen = Spawn(Class'FlyGenerator', , , Location, Rotation);
}

function Landed(vector HitNormal)
{
	local Rotator rot;
	local sound hitSound;

	// make it lay flat on the ground
	bFixedRotationDir = False;
	rot = Rotation;
	rot.Pitch = 0;
	rot.Roll = 0;
	SetRotation(rot);
	if (Velocity.Z <= -200)
	{
		if (fragType == class'PaperFragment')
		{
			hitSound = sound'Fart';
		}

	if (hitSound != None)
			PlaySound(hitSound, SLOT_None);

		// alert NPCs that I've landed
		AISendEvent('LoudNoise', EAITYPE_Audio);
	}

	bWasCarried = false;
	bBobbing    = false;

	// The crouch height is higher in multiplayer, so we need to be more forgiving on the drop velocity to explode
	if ( Level.NetMode != NM_Standalone )
	{
		if ((bExplosive && (VSize(Velocity) > 478)) || (!bExplosive && (Velocity.Z < -500)))
			TakeDamage((1-Velocity.Z/30), Instigator, Location, vect(0,0,0), 'fell');
	}
	else
	{
		if ((bExplosive && (VSize(Velocity) > 425)) || (!bExplosive && (Velocity.Z < -500)))
			TakeDamage((1-Velocity.Z/30), Instigator, Location, vect(0,0,0), 'fell');
	}
}

defaultproperties
{
     FragType=Class'DeusEx.PaperFragment'
     bGenerateFlies=True
     ItemName="DooDoos"
     PushSound=Sound'Markistan.Misc.Fart'
     Mesh=LodMesh'Markistan.Turd'
     CollisionRadius=9.000000
     CollisionHeight=16.250000
}
